/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.net.UnknownHostException;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.StorageType;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.storage.sDisk;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sStorageUtil
implements StorageConstants {
    private static String m_localHost = null;
    private static boolean s_isOCFSsupported;
    private static int OCFS_TYPE;
    private static boolean RAW_ENABLED;

    public static boolean isOCFS2supported() {
        return !s_isOCFSsupported;
    }

    public boolean isTypeValid(int type) {
        return type > 0;
    }

    public static int[] getDiscoveryTypes() {
        return sStorageUtil.getDiscoveryTypes(OracleFileType.RAC_DATA_FILES, "12.1", false);
    }

    public static int[] getDiscoveryTypes(OracleFileType fileType, String release, boolean considerASMStorage) {
        int[] discoveryTypes = null;
        if (fileType.equals((Object)OracleFileType.ASM)) {
            if (StorageUtil.isRawDiscoveryEnabled()) {
                discoveryTypes = new int[]{1};
            }
        } else {
            discoveryTypes = fileType.equals((Object)OracleFileType.RAC_SOFTWARE) || fileType.equals((Object)OracleFileType.SI_SOFTWARE) || fileType.equals((Object)OracleFileType.RAC_DATA_FILES) || fileType.equals((Object)OracleFileType.SI_DATA_FILES) ? sStorageUtil.getSoftwareDataFilesDiscoveryTypes(release, considerASMStorage) : sStorageUtil.getOcrVdiskDiscoveryTypes(release, considerASMStorage);
        }
        return discoveryTypes;
    }

    private static int[] getSoftwareDataFilesDiscoveryTypes(String release, boolean considerASMStorage) {
        if (VerificationUtil.isVersionPre(release, "11.2")) {
            if (RAW_ENABLED) {
                return new int[]{2, OCFS_TYPE, 1};
            }
            return new int[]{2, OCFS_TYPE};
        }
        if (RAW_ENABLED) {
            return new int[]{2, OCFS_TYPE, 13, 14, 1};
        }
        return new int[]{2, OCFS_TYPE, 13, 14};
    }

    private static int[] getOcrVdiskDiscoveryTypes(String release, boolean considerASMStorage) {
        if (VerificationUtil.isVersionPre(release, "11.2")) {
            if (RAW_ENABLED) {
                return new int[]{2, OCFS_TYPE, 1};
            }
            return new int[]{2, OCFS_TYPE};
        }
        if (VerificationUtil.isVersionPre(release, "12")) {
            if (RAW_ENABLED) {
                return new int[]{2, OCFS_TYPE, 13, 14, 1};
            }
            return new int[]{2, OCFS_TYPE, 13, 14};
        }
        boolean bc = false;
        try {
            bc = NodeManagerFactory.getInstance().getNodeManager().isBigCluster();
        }
        catch (NodeManagerFactoryException e) {
            Trace.out((int)5, (String)"Ignored exception: %s: %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
        }
        if (bc) {
            if (considerASMStorage && RAW_ENABLED) {
                return new int[]{13, 14, 1};
            }
            return new int[]{13, 14};
        }
        if (considerASMStorage && RAW_ENABLED) {
            return new int[]{2, OCFS_TYPE, 13, 14, 1};
        }
        return new int[]{2, OCFS_TYPE, 13, 14};
    }

    public static int[] getSupportedFileTypes(OracleFileType fileType, String release, boolean considerASMStorage) {
        if (OracleFileType.ASM.equals((Object)fileType)) {
            return new int[]{1};
        }
        int[] discoveryTypes = sStorageUtil.getDiscoveryTypes(fileType, release, considerASMStorage);
        boolean bc = false;
        try {
            bc = NodeManagerFactory.getInstance().getNodeManager().isBigCluster();
        }
        catch (NodeManagerFactoryException e) {
            Trace.out((int)5, (String)"Ignored exception: %s: %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
        }
        if (bc && fileType.equals((Object)OracleFileType.RAC_OCR_VDISK)) {
            return discoveryTypes;
        }
        int[] supportedFileTypes = new int[discoveryTypes.length + 1];
        System.arraycopy(discoveryTypes, 0, supportedFileTypes, 0, discoveryTypes.length);
        supportedFileTypes[discoveryTypes.length] = 17;
        if (fileType.equals((Object)OracleFileType.RAC_SOFTWARE) || fileType.equals((Object)OracleFileType.SI_SOFTWARE)) {
            int[] tempFileTypes = new int[supportedFileTypes.length + 1];
            System.arraycopy(supportedFileTypes, 0, tempFileTypes, 0, supportedFileTypes.length);
            tempFileTypes[supportedFileTypes.length] = 5;
            supportedFileTypes = tempFileTypes;
        }
        return supportedFileTypes;
    }

    public static String getTypeStr(int type) {
        return StorageUtil.getTypeStr(type);
    }

    public static StorageType getTypeEnum(int type) {
        return StorageUtil.getTypeEnum(type);
    }

    public static int getTypeByStr(String str) throws StorageException {
        return StorageUtil.getTypeByStr(str);
    }

    protected static String getLocalHost() throws StorageException {
        if (null == m_localHost) {
            try {
                m_localHost = VerificationUtil.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new StorageException("7007", e);
            }
        }
        return m_localHost;
    }

    public static int getNumDiskPartitions(StorageInfo stInfo) {
        if (stInfo.getType() == 1) {
            return ((sDisk)stInfo).getNumPartitions();
        }
        return -1;
    }

    static {
        OCFS_TYPE = 8;
        String distID = VerificationUtil.getUniqueDistributionID();
        boolean bl = s_isOCFSsupported = distID.equalsIgnoreCase("RHEL3") || distID.equalsIgnoreCase("OEL3") || distID.equalsIgnoreCase("RHEL2");
        if (s_isOCFSsupported) {
            OCFS_TYPE = 7;
        }
        RAW_ENABLED = StorageUtil.isRawDiscoveryEnabled();
    }
}

